import grass.script as gs

def main():
    input_raster = 'ndvi20050906'
    output_raster = 'high_NDVI'
    stats = gs.parse_command('r.univar', map='ndvi20050906', flags='g')
    raster_mean = float(stats['mean'])
    raster_stddev = float(stats['stddev'])
    raster_high = raster_mean + raster_stddev
    gs.mapcalc('{r} = {a} > {m}'.format(r=output_raster, a=input_raster,
                                        m=raster_high))

if __name__ == "__main__":
    main()