## set working directory
setwd('Y:/IGARSS/RF_Var_Reduction_Alfred/PV_TP')
############################################
## sourced script must be either a full path to the RF_functions script or a copy of it within the working directory
source('RF_functions_20190627.R')  ## do not modify (unless changing to a more recent version of this script)
############################################

# get a copy of the documentation list
doc <- documentation()

# get settings list, with all settings as default
# - settings are stored in two sub-list:
#     sett$data (data settings)   and   sett$rf (random forest model settings)
sett <- prep_sett() ## do not modify

# view the current state of the settings
print_sett(sett)

# documentation for individual settings can be accessed by using a combination of:
#  - the cat() function
#  - the component of the doc list that has the same name as the setting (or function) of interest
# For example:
cat(doc$load_from_json)
cat(doc$inRefCSV)
cat(doc$FN_classnum)
cat(doc$ntree)

# a text file representing all of the documentation can be generated with:
doc = documentation(outTextFile='Output/RandomForestFunctions_documentation.txt')

############################################
## data settings (modify and add settings to this section as needed)
## optional settings that are not modified in this section will run with the defaults 
sett$data$inRefCSV    = 'Input/Training_Validation_Balanced_65_cleaned.csv' ## if only filename, then the file must be in working dir
sett$data$FN_pointID  = 'FID'
sett$data$FN_classnum = 'ClassID'
sett$data$FN_classlab = 'Class'
sett$data$FN_xy       = c('POINT_X','POINT_Y')
sett$data$inRastPath  = 'Input/Alfred_2013_2014_1_LIDAR.pix' ## if only filename, then the file must be in working dir
sett$data$impute_strategy = NA
sett$data$consol_outCSV_dir = 'Output'
############################################
## random forest classifier settings (modify this section as needed)
sett$rf$ntree      = 1000
sett$rf$importance = TRUE
############################################

# view the current state of the settings after adjustments
print_sett(sett)

# optionally, save a copy of the current state of the settings
sett$data$save_to_json = 'Output/_myDataSettings.json'
sett$rf$save_to_json   = 'Output/_myRandomForestSettings.json'
save_sett(sett) # save

## number of iterations to perform
n_iterations <- 10
############################################
## read and prep data
a <- a_initialDataPrep(sett)
b <- b_imputeDataAndSplitIndValidSet(refdat=a$refdat,sett=sett,verbose=TRUE)
##
rf_list    <- list()
valid_list <- list()
for (i in 1:n_iterations){
  print(i)
  #### only save a copy of refdat  and impdat on interation 1:
  if (i == 1) sett$data$saveDataCSV <- 'Output/refdat_iter1.csv' else sett$data$saveDataCSV <- NA
  if (i == 1) sett$data$saveImputedDataCSV <- 'Output/impdat_iter1.csv' else sett$data$saveImputedDataCSV <- NA
  #### OR save a copy of refdat and impdat for each iteration (a lot will just be duplicated from other iters though):
  #sett$data$saveDataCSV <- paste0('refdat_iter',i,'.csv')
  #sett$data$saveImputedDataCSV<- paste0('impdat_iter',i,'.csv')
  #### prep random forest
  c <- c_prepRandomForest(refdat=b$refdat,impdat=b$impdat,sett=sett)
  #### store the classifier from each iteration in rf_list and validation results in valid_list
  rf_list[[i]] <- c$rf
  valid_list[[i]] <- d_independentValidation(refdat=c$refdat,sett=sett)
}
## consolidate results and save to CSV files
consol <- e_consolidateArossIterations(dat=c$refdat,sett=sett,valid=valid_list,rf=rf_list)

## view consolidated output
names(consol) # the names of the consoled data lists
View(consol$accStats)
View(consol$featureImportances)

